VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Integra Series IVI Driver - Module Detection Example"
   ClientHeight    =   6915
   ClientLeft      =   2475
   ClientTop       =   1800
   ClientWidth     =   8160
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6915
   ScaleWidth      =   8160
   Begin VB.TextBox txtStatus 
      Enabled         =   0   'False
      Height          =   525
      Left            =   840
      MultiLine       =   -1  'True
      TabIndex        =   36
      Top             =   5520
      Width           =   6255
   End
   Begin VB.Frame Frame1 
      Caption         =   "Slot 2 Module Info"
      Height          =   3015
      Index           =   1
      Left            =   4200
      TabIndex        =   20
      Top             =   2280
      Width           =   3135
      Begin VB.Label lblSlot1Module 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   34
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label Label2 
         Caption         =   "Model :"
         Height          =   255
         Index           =   1
         Left            =   360
         TabIndex        =   33
         Top             =   360
         Width           =   615
      End
      Begin VB.Label lblSlot1SN 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   32
         Top             =   720
         Width           =   1215
      End
      Begin VB.Label Label4 
         Caption         =   "Serial Number :"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   31
         Top             =   720
         Width           =   1095
      End
      Begin VB.Label lblSlot1FW 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   30
         Top             =   1080
         Width           =   1215
      End
      Begin VB.Label lblSlot1MUX 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   29
         Top             =   1440
         Width           =   1215
      End
      Begin VB.Label lblSlot1ISO 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   28
         Top             =   1800
         Width           =   1215
      End
      Begin VB.Label lblSlot1CJC 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   27
         Top             =   2160
         Width           =   1215
      End
      Begin VB.Label lblSlot1MaxVolts 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   26
         Top             =   2520
         Width           =   1215
      End
      Begin VB.Label Label3 
         Caption         =   "Module Firmware :"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   25
         Top             =   1080
         Width           =   1335
      End
      Begin VB.Label Label5 
         Caption         =   "Has MUX?"
         Height          =   255
         Index           =   1
         Left            =   600
         TabIndex        =   24
         Top             =   1440
         Width           =   975
      End
      Begin VB.Label Label6 
         Caption         =   "Isolated Chan : "
         Height          =   255
         Index           =   1
         Left            =   360
         TabIndex        =   23
         Top             =   1800
         Width           =   1215
      End
      Begin VB.Label Label7 
         Caption         =   "Has CJC? : "
         Height          =   255
         Index           =   1
         Left            =   600
         TabIndex        =   22
         Top             =   2160
         Width           =   975
      End
      Begin VB.Label Label8 
         Caption         =   "MAX Volts : "
         Height          =   255
         Index           =   1
         Left            =   600
         TabIndex        =   21
         Top             =   2520
         Width           =   975
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Slot 1 Module Info"
      Height          =   3015
      Index           =   0
      Left            =   720
      TabIndex        =   5
      Top             =   2280
      Width           =   3135
      Begin VB.Label Label8 
         Caption         =   "MAX Volts : "
         Height          =   255
         Index           =   0
         Left            =   600
         TabIndex        =   19
         Top             =   2520
         Width           =   975
      End
      Begin VB.Label Label7 
         Caption         =   "Has CJC? : "
         Height          =   255
         Index           =   0
         Left            =   600
         TabIndex        =   18
         Top             =   2160
         Width           =   975
      End
      Begin VB.Label Label6 
         Caption         =   "Isolated Chan : "
         Height          =   255
         Index           =   0
         Left            =   360
         TabIndex        =   17
         Top             =   1800
         Width           =   1215
      End
      Begin VB.Label Label5 
         Caption         =   "Has MUX?"
         Height          =   255
         Index           =   0
         Left            =   600
         TabIndex        =   16
         Top             =   1440
         Width           =   975
      End
      Begin VB.Label Label3 
         Caption         =   "Module Firmware :"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   15
         Top             =   1080
         Width           =   1335
      End
      Begin VB.Label lblSlot1MaxVolts 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   0
         Left            =   1680
         TabIndex        =   14
         Top             =   2520
         Width           =   1215
      End
      Begin VB.Label lblSlot1CJC 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   0
         Left            =   1680
         TabIndex        =   13
         Top             =   2160
         Width           =   1215
      End
      Begin VB.Label lblSlot1ISO 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   0
         Left            =   1680
         TabIndex        =   12
         Top             =   1800
         Width           =   1215
      End
      Begin VB.Label lblSlot1MUX 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   0
         Left            =   1680
         TabIndex        =   11
         Top             =   1440
         Width           =   1215
      End
      Begin VB.Label lblSlot1FW 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   0
         Left            =   1680
         TabIndex        =   10
         Top             =   1080
         Width           =   1215
      End
      Begin VB.Label Label4 
         Caption         =   "Serial Number :"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   9
         Top             =   720
         Width           =   1095
      End
      Begin VB.Label lblSlot1SN 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   0
         Left            =   1680
         TabIndex        =   8
         Top             =   720
         Width           =   1215
      End
      Begin VB.Label Label2 
         Caption         =   "Model :"
         Height          =   255
         Index           =   0
         Left            =   360
         TabIndex        =   7
         Top             =   360
         Width           =   615
      End
      Begin VB.Label lblSlot1Module 
         BackColor       =   &H8000000E&
         Height          =   255
         Index           =   0
         Left            =   1680
         TabIndex        =   6
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.TextBox txtResourceID 
      Height          =   285
      Left            =   3480
      TabIndex        =   4
      Text            =   "GPIB0::16::INSTR"
      ToolTipText     =   "Enter Resource ID for your Integra Series"
      Top             =   960
      Width           =   2055
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close Session"
      Height          =   375
      Left            =   720
      TabIndex        =   3
      Top             =   6240
      Width           =   2415
   End
   Begin VB.CommandButton cmdDetect 
      Caption         =   "Detect Modules"
      Enabled         =   0   'False
      Height          =   375
      Left            =   720
      TabIndex        =   2
      Top             =   1560
      Width           =   2415
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   720
      TabIndex        =   1
      Top             =   960
      Width           =   2415
   End
   Begin VB.Label lblModel 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2760
      TabIndex        =   37
      Top             =   240
      Width           =   4575
   End
   Begin VB.Label Label9 
      Caption         =   "Resource Name: "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3480
      TabIndex        =   35
      Top             =   720
      Width           =   1335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   360
      TabIndex        =   0
      Top             =   240
      Width           =   1845
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim vi As ViSession  ' global variable for our session
Dim status As ViStatus  ' global variable for error checking

Private Sub cmdClose_Click()
' close only if valid session
If vi <> 0 Then status = KE2700_close(vi)
End
End Sub

Private Sub cmdDetect_Click()

Dim slot As String  'ViConstString
Dim model As String
Dim modelNumber As ViInt32
Dim serialNum As ViInt32
Dim FWversion As String
Dim MUXFeature As ViBoolean
Dim IsoChan As ViBoolean
Dim hasCJC As ViBoolean
Dim maxVolts As ViReal64

slot = "1"  ' slots are numbered one and higher
' 2700 and 2701 have only slot 1 and 2
' 2750 has slots 1 through 5

status = KE2700_GetCardInfo(vi, _
                            slot, _
                            model, _
                            serialNum, _
                            FWversion, _
                            MUXFeature, _
                            IsoChan, _
                            hasCJC, _
                            maxVolts)
status = KE2700_GetAttributeViInt32(vi, slot, KE2700_ATTR_CARD_TYPE, modelNumber)
If modelNumber <> 0 Then  'only if we have module installed should we ask for FWversion
FWversion = String$(256, 0)  ' else the program errors out
status = KE2700_GetAttributeViString(vi, slot, KE2700_ATTR_CARD_FW_VERSION, 256, FWversion)
End If

' display the data for slot 1 card
If modelNumber = 0 Then
lblSlot1Module(0).Caption = "none detected"
Else
lblSlot1Module(0).Caption = modelNumber
lblSlot1SN(0).Caption = serialNum
lblSlot1FW(0).Caption = FWversion  '"not avail"
lblSlot1MUX(0).Caption = MUXFeature
lblSlot1ISO(0).Caption = IsoChan
lblSlot1CJC(0).Caption = hasCJC
lblSlot1MaxVolts(0).Caption = maxVolts
End If
'
' now for second slot
slot = "2"
status = KE2700_GetCardInfo(vi, _
                            slot, _
                            model, _
                            serialNum, _
                            FWversion, _
                            MUXFeature, _
                            IsoChan, _
                            hasCJC, _
                            maxVolts)
                            
status = KE2700_GetAttributeViInt32(vi, slot, KE2700_ATTR_CARD_TYPE, modelNumber)

If modelNumber <> 0 Then
FWversion = String$(256, 0)
status = KE2700_GetAttributeViString(vi, slot, KE2700_ATTR_CARD_FW_VERSION, 256, FWversion)
End If

' display the data for slot 2 card
If modelNumber = 0 Then
lblSlot1Module(1).Caption = "none detected"
Else
lblSlot1Module(1).Caption = modelNumber
lblSlot1SN(1).Caption = serialNum
lblSlot1FW(1).Caption = FWversion
lblSlot1MUX(1).Caption = MUXFeature
lblSlot1ISO(1).Caption = IsoChan
lblSlot1CJC(1).Caption = hasCJC
lblSlot1MaxVolts(1).Caption = maxVolts
End If
Beep
CheckError vi, status
End Sub

Private Sub cmdInit_Click()
' For RS-232 connections use "ASRL1::INSTR" as Resource String
' For Ines GPIB cards, use GPIB1::16::INSTR
' for NI or CEC, use GPIB0::16::INSTR
'
' for 2701 Ethernet based connection, typical resource string would be
' "TCPIP::192.68.1.10::1394::SOCKET"
' modify above according to the IP address assigned to your 2701

Dim InstrumentName As String
InstrumentName = txtResourceID.Text
status = KE2700_InitWithOptions(InstrumentName, _
                                  VI_TRUE, _
                                  VI_TRUE, _
                                  "Simulate=0,RangeCheck=1,QueryInstrStatus=1,Cache=1", _
                                  vi)
'status = KE2700_init(InstrumentName, VI_TRUE, VI_TRUE, vi)


 
If status = 0 Then
'enable other command buttons
cmdDetect.Enabled = True
txtStatus.Text = "Session Opened without Error"
' read out the model number of the particular 27xx mainframe
Dim model As String
Dim bufSize As ViInt32
bufSize = 12
model = String$(bufSize, 0)
status = KE2700_GetAttributeViString(vi, "", KE2700_ATTR_INSTRUMENT_MODEL, 256, model)
lblModel.Caption = "Detected Mainframe: " & model
Else
  CheckError vi, status
End If
End Sub



' Routine:
'   CheckError

' Purpose:
'   This routine checks the return value of the given IVI function call.
'   It constructs an error message if an error occurs.

'   If the ErrorCode is greater than &HBFFF0000, then the error is reported by the IVI
'   Driver, otherwise, it's reported directly from the hardware instrument.
'   For errors reported by IVI Driver, use KE2700_error_message to retrieve the error code.
'   For errors reported by instruments, use KE2700_query_error

' Return:
'  None

' Exception:
'   If <ErrorCode> does indicate an error condition, then a constructed error is raised
'   to the caller.

Private Sub CheckError(ByVal vi As ViSession, ByVal ErrorCode As ViStatus)
  Dim ErrMsg As String
  Dim buffer As String
  Dim ErrCode As ViStatus
  Dim PrimaryErr As ViStatus
  Dim SecondaryErr As ViStatus
  Dim ElaborationErr As String

  If ErrorCode = VI_SUCCESS Then Exit Sub
  ErrMsg = ErrMsg & "Primary Error: (Hex " & Hex(ErrorCode) & ")" & vbCrLf
  buffer = Space$(256)

  If ErrorCode <> &HBFFA0001 Then ' IVI_ERROR_INSTR_SPECIFIC =  &HBFFA0001
    ' Error reported by IVI Driver
    KE2700_error_message vi, ErrorCode, buffer
    ErrMsg = ErrMsg & Trim$(buffer)
    ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
    KE2700_GetErrorInfo vi, PrimaryErr, SecondaryErr, ElaborationErr
  
    If PrimaryErr = ErrorCode And SecondaryErr <> 0 Then
      ' Check secondary error if there is any
      ErrMsg = ErrMsg & "Secondary Error: (Hex " & Hex(SecondaryErr) & ")" & vbCrLf
      KE2700_error_message vi, SecondaryErr, buffer
      ErrMsg = ErrMsg & Trim$(buffer)
      ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
      ' Check Elaboration error if there is any
      If Len(ElaborationErr) Then
        ErrMsg = ErrMsg & "Elaboration: " & ElaborationErr
      End If
    End If

  Else
    ' Error reported by instrument.
    KE2700_error_query vi, ErrorCode, buffer
    ErrMsg = ErrMsg & Trim$(buffer)
    ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
  End If

  'if not a warning, Raise error to the caller
  If ErrorCode <> 0 Then
  'Err.Raise ErrorCode, "IVI Driver Examples", ErrMsg
  txtStatus.Text = ErrMsg  ' instead of raise error, display error message
  End If
End Sub
